<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Admin.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";


// Init DB connection
$database = new Database();
$db = $database->connect();

// Init admin object
$admin = new Admin($db);

// Store read method result in variable & count rows
$result = $admin->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // admin array
        $admin_arr = array();
        $admin_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each admin will look like this
            $admin = array(
                'admin_id' => $admin_id,
                'user_id' => $user_id,
                'admin_role' => $admin_role
            );

            // Push to "Data"
            array_push($admin_arr["data"], $admin);
        }
        // Convert result to JSON
        echo json_encode($admin_arr);
    } else {
        // No admins returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No admins found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read admins."
        )
    );
}




