<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/AdminPlace.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init admin place object
$adminPlace = new AdminPlace($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$adminPlace->admin_place_id = $data->admin_place_id;
$adminPlace->admin_place_name = $data->admin_place_name;
$adminPlace->admin_place_address = $data->admin_place_address;
$adminPlace->admin_place_city = $data->admin_place_city;
$adminPlace->admin_id = $data->admin_id;

if(check_auth()){
    if ($adminPlace->update()) {
        echo json_encode(array("message" => "Admin place updated"));
    } else {
        echo json_encode(array("message" => "Admin place not updated"));
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update admin place."
        )
    );
}
