<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/AdminPlace.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init adminPlace object
$adminPlace = new AdminPlace($db);
$adminPlace->admin_place_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$adminPlace->read_single();


// adminPlace array
$adminPlace_arr = array(
    "admin_place_id" => $adminPlace->admin_place_id,
    "admin_place_name" => $adminPlace->admin_place_name,
    "admin_place_address" => $adminPlace->admin_place_address,
    "admin_google_maps_link" => $adminPlace->admin_google_maps_link,
    "admin_place_city" => $adminPlace->admin_place_city,
    "admin_id" => $adminPlace->admin_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($adminPlace_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read admin place."
        )
    );
}