<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/AdminPlace.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init adminPlace object
$adminPlace = new AdminPlace($db);

$admin_id = isset($_GET["admin_id"]) ? $_GET["admin_id"] : die();

// Store read method result in variable & count rows
$result = $adminPlace->read($admin_id);
$num = $result->rowCount();

if(!check_auth()){
    if ($num > 0) {
        // adminPlace array
        $adminPlace_arr = array();
        $adminPlace_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each adminPlace will look like this
            $adminPlace = array(
                'admin_place_id' => $admin_place_id,
                'admin_place_name' => $admin_place_name,
                'admin_place_address' => $admin_place_address,
                'admin_google_maps_link' => $admin_google_maps_link,
                'admin_place_city' => $admin_place_city  
            );

            // Push to "Data"
            array_push($adminPlace_arr["data"], $adminPlace);
        }
        // Convert result to JSON
        echo json_encode($adminPlace_arr);
    } else {
        // No admin places returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No admin places found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read admin places."
        )
    );
}




