<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: DELETE");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/AdminPlace.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init ab object
$adminPlace = new AdminPlace($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$adminPlace->admin_place_id = $data->admin_place_id;

if(check_auth()){
    // Create admin place
    if ($adminPlace->delete()) {
        echo json_encode(
            array("message" => "Admin place deleted")
        );
    } else {
        echo json_encode(
            array("message" => "Admin place not deleted")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to delete admin place."
        )
    );
}