<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../../config/Database.php";
include_once "../../../models/Company.php";
include_once "../../../config/authorization.php";
include_once "../../../config/functions.php";

$database = new Database();
$db = $database->connect();

$company =  new Company($db);
$admin_id = $_GET['admin_id'];

$result = $company->getAdminCompanies($admin_id);
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {

        $company_arr = array();
        $company_arr['data'] = array();

        while($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            $company = array (
                'company_id' => $company_id,
                'company_name' => $company_name
            );

            array_push($company_arr['data'], $company );
        }

        echo json_encode($company_arr);   

    } else {

        echo json_encode(
            array(
                "message" => "No admin companies found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read companies by admin id."
        )
    );
}    