<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/AddressBook.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init ab object
$addressBook = new AddressBook($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$addressBook->address_book_id = $data->address_book_id;
$addressBook->ab_name = $data->ab_name;
$addressBook->ab_email = $data->ab_email;

if(!check_auth()){
    // Create ab
    if ($addressBook->update()) {
        echo json_encode(
            array("message" => "Address Book contact updated")
        );
    } else {
        echo json_encode(
            array("message" => "Address Book contact not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update adress book contact."
        )
    );
}