<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/AddressBook.php";
//include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init address book object
$addressBook = new AddressBook($db);

// GET compay_id from URL 
$company_id =  isset($_GET["company_id"]) ? $_GET["company_id"] : die();
// Store read method result in variable & count rows
$result = $addressBook->read($company_id);
$num = $result->rowCount();

if(!check_auth()){
    if ($num > 0) {
        // address book array
        $addressBook_arr = array();
        $addressBook_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each address book will look like this
            $addressBook = array(
                'address_book_id' => $address_book_id,
                'ab_name' => $ab_name,
                'ab_email' => $ab_email
            );

            // Push to "Data"
            array_push($addressBook_arr["data"], $addressBook);
        }
        // Convert result to JSON
        echo json_encode($addressBook_arr);
    } else {
        // No address book returned from query
        header("HTTP/1.1 404");
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No address book found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read adress book contacts."
        )
    );
}