<?php 
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: Content-Type, origin");


include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/AddressBook.php";

// Init DB connection
$database = new Database();
$db = $database->connect();
// Disable foreign key checks
$db->query("SET foreign_key_checks = 0");

// Init address book object
$addressBook = new AddressBook($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));
$addressBook->ab_name = $data->ab_name;
$addressBook->ab_email = $data->ab_email;
$addressBook->company_id = $data->company_id;

if(!check_auth()){
    // Create
    if ($addressBook->create() && $addressBook->ab_name != null && $addressBook->ab_email != null && $addressBook->company_id != null) {
        echo json_encode(
            array(
                "status" => 200,
                "message" => "Address Book contact created"
                )
        );
    } else {
        //header('Content-Type: application/json');
        //header("HTTP/1.1 406");
        echo json_encode(
            array(
                "status" => 406,
                "message" => "No content"
                )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to create adress book contact."
        )
    );
}