<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
header("Access-Control-Allow-Methods: PUT");
header("Access-Control-Allow-Headers: Access-Control-Allow-Headers, Content-Type, Access-Control-Allow-Methods, Authorization, X-Requested-With");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Activity.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init activity object
$activity = new Activity($db);

// Get raw data
$data = json_decode(file_get_contents("php://input"));

$activity->act_id = $data->act_id;
$activity->act_title = $data->act_title;
$activity->area_id = $data->area_id;

if(check_auth()){
    // Create activity
    if ($activity->update()) {
        echo json_encode(
            array("message" => "Activity updated")
        );
    } else {
        echo json_encode(
            array("message" => "Activity not updated")
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to update activity."
        )
    );
}