<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../config/functions.php";
include_once "../../models/Activity.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init activity object
$activity = new Activity($db);
$activity->act_id = isset($_GET["id"]) ? $_GET["id"] : die();

// Store read method result in variable 
$activity->read_single();


// activity array
$activity_arr = array(
    "act_id" => $activity->act_id,
    "act_title" => $activity->act_title,
    "area_id" => $activity->area_id
);

if(check_auth()){
    // Convert resutl to JSON
    print_r(json_encode($activity_arr));
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read activity."
        )
    );
}