<?php 
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

include_once "../../config/Database.php";
include_once "../../models/Activity.php";
include_once "../../config/authorization.php";
include_once "../../config/functions.php";

// Init DB connection
$database = new Database();
$db = $database->connect();

// Init activity object
$activity = new Activity($db);

// Store read method result in variable & count rows
$result = $activity->read();
$num = $result->rowCount();

if(check_auth()){
    if ($num > 0) {
        // Activity array
        $activity_arr = array();
        $activity_arr["data"] = array();

        while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            // Each activity will look like this
            $activity = array(
                'act_id' => $act_id,
                'act_title' => $act_title,
                'area_id' => $area_id,
            );

            // Push to "Data"
            array_push($activity_arr["data"], $activity);
        }
        // Convert result to JSON
        echo json_encode($activity_arr);
    } else {
        // No activities returned from query
        echo json_encode(
            array(
                "status" => 404,
                "message" => "No activities found"
            )
        );
    }
} else {
    echo json_encode(
        array(
            "status" => 401,
            "message" => "Not authorized to read activities."
        )
    );
}




